var fg_files = [];
var bg_files = [];

$(function () {
   'use strict';
   
    var flag = $("#flag").val();
    if (flag === "1") window.location.reload();
    $("#flag").val("1");

    var files4upload = [];
    var uploaded_files = 0;
    var save_dir = null;

    $('#fileupload').bind('fileuploadchange', function (e, data) {
        // set  working dir if not set
        if ($("#sd").val() == "") {
            set_sd();
        }
	var organism = $("#organism_row label.active input").val() === undefined ? "" : $("#organism_row label.active input").val();
	if (organism == "") {
	    alert("Please select an organism!");
	}
    });

    $('#fileupload').bind('fileuploadadd', function (e, data) {
        /* check file type */
        var acceptFileTypes = /(\.|\/)(fasta|fa|fas|fna|fastq|bam|bed|gz|bz2|zip|tar)$/i
        if (acceptFileTypes.exec(data.files[0].name) == null) {
            alert("Unsupported file format! Click cancel button to remove it from the file list.");
            return null;
        }
        var existing_files = [];
        if (data.paramName == "fg_files[]") {
            fg_files.push(data.files[0].name);
        }
        else {
            bg_files.push(data.files[0].name);
        }
        $("#fileupload table td .name").each(function(e, v){existing_files.push($(v).html());});
        data.files = $.map(data.files, function(file,i){
            if ($.inArray(file.name,existing_files) >= 0) {alert("Duplicated file! Click cancel button to remove it from the file list.");return null; }
            return file;
        });
	var organism = $("#organism_row label.active input").val() === undefined ? "" : $("#organism_row label.active input").val();
	if (organism == "") {
	    alert("Please choose an organism!");
	}
    });

    $('#fileupload').bind('fileuploadfailed', function (e, data) {
        if (data.files[0].error === null) {
            files4upload.splice(files4upload.indexOf(data.files[0].name), 1);
        }
    });

    $('#fileupload').bind('fileuploadstarted', function (e, data) {
	    $(".cancel").hide();
	    save_user_data_before_upload();
	});
    
    $('#fileupload').bind('fileuploadcompleted', function (e, data) {
        uploaded_files += 1;
        /* check if number of uploaded files is equal to number of files in table */
        if (uploaded_files == $("#fileupload table td .name").length) {
                submit_user_data("files");
        }
    });

    $('#fileupload').fileupload({
        maxChunkSize: 10000000,
	sequentialUploads: true,
        acceptFileTypes: /(\.|\/)(fastq|gz)$/i
    });

    $("#optional").accordion({
	    collapsible: true,
	    heightStyle: "content"
		});
    $("#upload_section").accordion({
	    collapsible: true,
	    heightStyle: "content"
		});

    $("#email").tooltip();
    $("#project").tooltip();
    $("#submit_links").click(function(){
	    set_sd(function (){save_user_data_before_upload();submit_user_data();});
    });
    $("#submit_srr").click(function(){
	    set_sd(function (){save_user_data_before_upload();submit_user_data();});
    });
});

function submit_user_data() {
    /* check if upload dir is set */
    if ($("#sd").val() == '') {
        alert("ERROR: Failed to set working directory!");
        return false;
    }

    //var organism = $("#organism input:checked").val() === undefined ? "" : $("#organism input:checked").val();
    var organism = $("#organism_row label.active input").val() === undefined ? "" : $("#organism_row label.active input").val();
    if (organism == "") {
	alert("Please choose an organism!");
	return(false);
    }
    /* check if bg present in upload if organism is not numan */
    var bg_present = false;
    if ($("#bg_links").val() != "") {
	bg_present = true;
    }
    if ($("#bg_srr").val() != "") {
	bg_present = true;
    }
    if (bg_files.length > 0) {
	bg_present = true;
    }
    
    if (organism != "hg19" && !bg_present) {
	alert("Please provide background files as well!");
	return(false);
    }

    var email = $("#email").val();
    var project = $("#project").val();
    var fg_window = $("#fg_window").val();
    var bg_window = $("#bg_window").val();
    var step = $("#step").val();
    var fdr = $("#fdr").val();
    var adaptor = $("#adaptor").val();
    var sd = $("#sd").val();
    var fg_links = $("#fg_links").val();
    var bg_links = $("#bg_links").val();
    var fg_srr = $("#fg_srr").val();
    var bg_srr = $("#bg_srr").val();
    $.post("/crunch/run", {
	    "email": email,
		"project": project,
		"organism": organism,
		"fg_window": fg_window,
		"bg_window": bg_window,
		"step": step,
		"fdr": fdr,
		"adaptor": adaptor,
		"sd": sd,
		"fg_links": fg_links,
		"bg_links": bg_links,
		"fg_srr": fg_srr,
		"bg_srr": bg_srr
		},
           function(x){
	       $("#sd").val("");
               if(x.match(/^data_\S+$/) !== null) {
                   window.location = "http://" + window.location.hostname + "/CRUNCH/scratch/" + x + "/report_IP";
               }
               else {
		   alert(x);
                   $(".container").html(x+"<br><br><h2><a href=''>Go back to main page</a></h2>");
               }
               $("#form").html("<br><br><h2>Done</h2>");
           });
}

function set_sd(callback) {
    //var url = window.location.pathname + "/get_sd";
    var url = "/crunch/get_sd";
    $.get(url, function(data) {
        console.log("data:");
        console.log(data);
        if (/^data_\S{6,}$/.test(data)) {
            $("#sd").val(data);
            console.log("SD set to " + data);
	    if (typeof callback === "function") {
		callback();
	    }
        } else {
            alert("ERROR: Failed to set working directory!");
        }
    });
}


function save_user_data_before_upload() {
    var data = {}
    data.organism = $("#organism_row label.active input").val() === undefined ? "" : $("#organism_row label.active input").val();
    data.email = $("#email").val();
    data.project = $("#project").val();
    data.fg_window = $("#fg_window").val();
    data.bg_window = $("#bg_window").val();
    data.step = $("#step").val();
    data.fdr = $("#fdr").val();
    data.adaptor = $("#adaptor").val();
    data.sd = $("#sd").val();
    data.fg_links = $("#fg_links").val();
    data.bg_links = $("#bg_links").val();
    data.fg_srr = $("#fg_srr").val();
    data.bg_srr = $("#bg_srr").val();
    data.submit_url = "/crunch/save_json";
    console.log("data for json: " + JSON.stringify(data));
    $.post(data.submit_url, {
	    "data": JSON.stringify(data),
		"sd": data.sd
		},
	function(x){
	    console.log(x);
	});
}
